<?php
class DB{

		private $dbNAME;
		private $dbSERVER;
		private $dbUSER;
		private $dbPASS;
		private $debug;
		private $row;
		private $preSQL = ""; //table prefix
	
			var $link_id = 0;
			var $query_id = 0;			
			var $Errno = 0;

			#######################
			//internal info
			var $error = "";
			var $errno = 0;
			
			//number of rows affected by SQL query
			var $affected_rows = 0;			

	function DB($db=DB_name, $host=DB_server, $user=DB_user, $pass=DB_pass, $preSQL='') {
			$this->dbNAME   = $db;
			$this->dbSERVER = $host;
			$this->dbUSER   = $user;
			$this->dbPASS   = $pass;	
			$this->preSQL=$preSQL;
			$this->dbConnect();
	}

	function Fechas($fecha){
		$sep = explode('-',$fecha);
		$mes = $sep[1];
		switch($mes){
			case 1  : $mes = 'ene'; break;
			case 2  : $mes = 'feb'; break;
			case 3  : $mes = 'mar'; break;
			case 4  : $mes = 'abr'; break;
			case 5  : $mes = 'may'; break;
			case 6  : $mes = 'jun'; break;
			case 7  : $mes = 'jul'; break;
			case 8  : $mes = 'ago'; break;
			case 9  : $mes = 'sep'; break;
			case 10 : $mes = 'oct'; break;
			case 11 : $mes = 'nov'; break;
			case 12 : $mes = 'dic'; break;			
		}
		$fecha = $sep[2].' '.$mes.' '.$sep[0];
		return $fecha;
	}

	protected function dbConnect(){
		$this->link_id = mysqli_connect($this->dbSERVER, $this->dbUSER, $this->dbPASS);
		
		if (!$this->link_id){
			$this->ErrorHandler("Server Connection Failed!!!" . $this->dbSERVER);
			return 0;
		}	
	
		if (!@mysqli_select_db($this->link_id, $this->dbNAME)) {
			$this->ErrorHandler("DataBase Connection Failed!!!".$this->dbNAME);
			return 0;
		}
			return $this->link_id;
	}

	function debug($debug=true){
		 $this->debug=$debug; 
	}

	#-#############################################
	# desc: close the connection
	function close() {
		if(!@mysql_close($this->link_id)){
			$this->ErrorHandler("Connection close failed!!!");
		}
	}#-#close()
	
	
	#-#############################################
	# Desc: escapes characters to be mysql ready
	# Param: string
	# returns: string
	function escape($string) {
		if(get_magic_quotes_runtime()) $string = stripslashes($string);
		return @mysql_real_escape_string($string,$this->link_id);
	}#-#escape()	

	function dbSQL($sql = ""){
		$this->query_id = @mysqli_query($this->link_id, $sql);
		
		if ($sql == ""){
			$this->ErrorHandler("<h2>empty SQL!!!</h2>");
			return 0;
		}
		
		if (!$this->query_id) {
			$this->ErrorHandler("<b>MySQL Query failed:</b> <em>$sql</em>");
			return 0;
		}
					
			if (!$this->query_id) {
				$this->Errno = mysql_errno();
				$this->ErrorHandler("<h2>" . mysqli_error() . "</h2>");
			}
		
		return $this->query_id;
	}

	public function dbField($field=false){
			if($field)
					return $this->row[$field];
			else 
					return $this->row;
	}		
	
	public function next($secure=''){
		if($secure===''){
				$this->row = mysqli_fetch_array($this->query_id);
		}else{
				$safe = new SafeHtml();
				$roughArray = mysqli_fetch_array($this->query_id);
			if(is_array($roughArray)){
				$secureArray = array();
				
				foreach ($roughArray as $key => $value){
					$secureArray[$key] = $safe->safeHtml($value);
				}
			$this->row = $secureArray;	
			}else 
				$this->row = false;
		}
	 return $this->row;	
	}	

# * * * * * * * * * * * * * * * * * * * * * * * * 
# return Number Fields of table
# * * * * * * * * * * * * * * * * * * * * * * * * 

	function NumFields() {
		return mysqli_num_fields($this->query_id);
	}

# * * * * * * * * * * * * * * * * * * * * * * * * 
# return Number Rows of table
# * * * * * * * * * * * * * * * * * * * * * * * * 
	function dbNumRows(){
		return mysqli_num_rows($this->query_id);
	}

# * * * * * * * * * * * * * * * * * * * * * * * * 
# return Row of table
# * * * * * * * * * * * * * * * * * * * * * * * * 
	function dbRow(){
		return $this->row;
	}

# * * * * * * * * * * * * * * * * * * * * * * * * 
# Free resources of table
# * * * * * * * * * * * * * * * * * * * * * * * * 
	function dbfree(){
		mysqli_free_result($this->query_id);
	}

# * * * * * * * * * * * * * * * * * * * * * * * * 
# show all Errors Matrix on a HTML Table
# * * * * * * * * * * * * * * * * * * * * * * * * 
private function ErrorHandler($msg='') {
	if($this->link_id > 0){
		$this->error = mysqli_error($this->link_id);
		$this->errno = mysqli_errno($this->link_id);
	}
 	else{
		$this->error = mysqli_error();
		$this->errno = mysqli_errno();
	}
	?>
<style>
body{ 
	font: Arial, Helvetica, sans-serif;
}
</style>
	<table width="100%" border="1" align="center" cellspacing="0">
		<tr>
			<th colspan=2>Database Error</th></tr>
		<tr>
			<td width="16%" align="right" valign="top">Message:</td>
			<td width="84%"><?php echo $msg ?></td>
		</tr>
		<?php 
		if(!empty($this->error)){
			echo '<tr>
			 			 <td align="right" nowrap>
						  	MySQL Error:</td>
						 <td>
						 	 '.$this->error.'</td></tr>'; 
		}//end if ?>
		<tr>
			<td align="right">Date:</td>
			<td>
				<?php echo date("l, F j, Y \a\\t g:i:s A"); ?></td></tr>
		<?php 
		if(!empty($_SERVER['REQUEST_URI'])){
			echo '<tr>
						 <td align="right">Script:</td>
						 <td>
						 	<a href="'.$_SERVER['REQUEST_URI'].'">
								'.$_SERVER['REQUEST_URI'].'</a></td></tr>';
		}//end if ?>
		<?php 
		if(!empty($_SERVER['HTTP_REFERER'])){
			echo '<tr>
						 <td align="right">Referer:</td>
						 <td>
						 	<a href="'.$_SERVER['HTTP_REFERER'].'">
								'.$_SERVER['HTTP_REFERER'].'</a></td></tr>';
		}//end if ?>
</table>
	<?php
	}#ErrorHandler 
    
}//End Class DB() ?>