<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Producto;
use App\Models\Venta;
use App\Models\Traspaso;
use App\Models\Sucursal;
use App\Models\Ubicacion;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    public function index()
    {
        Paginator::currentPageResolver(function () {
            return request()->input('productos_page') ?: 1;
        });

        // Productos con bajo stock
        $productosConBajoStock = Producto::where('cantidad', '<=', 10)->get();

        // Productos más vendidos
        $productosMasVendidos = DB::table('productos_vendidos')
            ->join('productos', 'productos_vendidos.producto_id', '=', 'productos.id')
            ->select('productos.nombre', 'productos.codigo1', DB::raw('SUM(productos_vendidos.cantidad_total) as total_vendido'))
            ->groupBy('productos.id', 'productos.nombre', 'productos.codigo1')
            ->orderByDesc('total_vendido')
            ->limit(5)
            ->get();

        $ventasPorFecha = DB::table('ventas_nueva')
            ->join('productos_vendidos', 'ventas_nueva.id', '=', 'productos_vendidos.venta_id')
            ->selectRaw('DATE(ventas_nueva.fecha) as fecha, SUM(productos_vendidos.cantidad_total) as total_ventas')
            ->groupBy('fecha')
            ->paginate(5, ['*'], 'ventas_page');

        $totalSucursales = Ubicacion::count();

        $ventasPorSucursalHoy = DB::table('ventas_nueva')
            ->join('productos_vendidos', 'ventas_nueva.id', '=', 'productos_vendidos.venta_id')
            ->select('ventas_nueva.ubicacion_id', DB::raw('SUM(productos_vendidos.cantidad_total) as total_ventas'))
            ->whereDate('ventas_nueva.fecha', today())
            ->groupBy('ventas_nueva.ubicacion_id')
            ->get();

        $totalEmpleados = User::whereHas('roles', function ($q) {
            $q->where('name', 'Empleado');
        })->count();

        return view('home', compact(
            'productosConBajoStock',
            'productosMasVendidos',
            'ventasPorFecha',
            'totalSucursales',
            'ventasPorSucursalHoy',
            'totalEmpleados'
        ));
    }
}
