<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ProductosImport;

class ImportController extends Controller
{
    public function importarProductos(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xls,xlsx'
        ]);

        $file = $request->file('file');

        Excel::import(new ProductosImport, $file);

        return redirect()->back()->with('success', 'Productos importados exitosamente.');
    }
}