<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Empleado extends Model
{
    use HasFactory;

    protected $table = 'empleados';
    protected $fillable = [
        'nombre',
        'apellidos',
        'carnet',
        'fecha_nacimiento',
        'direccion',
        'telefono',
        'correo',
        'ubicacion_id',
        'estado',
    ];

    public function sucursal()
    {
        return $this->belongsTo(Ubicacion::class, 'ubicacion_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
