<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Preventa extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'tienda_id',
        'nombre_cliente',
        'tel_cliente',
        'precio_total',
        'cantidad_total',
    ];
    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }
    
    public function detalles()
    {
        return $this->hasMany(DetallePreventa::class);
    }
    public function usuario()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function tienda()
    {
        return $this->belongsTo(Ubicacion::class, 'tienda_id');
    }
}
