<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVentasNuevaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ventas_nueva', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('ubicacion_id')->nullable()->constrained('ubicaciones')->onDelete('set null'); // Relación con ubicación general de la venta
            $table->decimal('precio_total', 10, 2); // Total de la venta
            $table->date('fecha'); // Fecha de la venta
            $table->time('hora'); // Hora de la venta
            $table->timestamps();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('ventas_nueva');
    }
    
}
