@extends('layouts.app')

@section('content')
<section class="section">
    <!-- Encabezado -->
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading">Registrar Cliente</h3>
       
    </div>
    {{-- Mostrar errores de validación --}}
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('clientes.store') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" name="nombre" id="nombre" class="form-control" value="{{ old('nombre') }}" required>
        </div>

        <div class="mb-3">
            <label for="apellidos" class="form-label">Apellidos</label>
            <input type="text" name="apellidos" id="apellidos" class="form-control" value="{{ old('apellidos') }}" required>
        </div>

        <div class="mb-3">
            <label for="carnet" class="form-label">Carnet</label>
            <input 
                type="text" 
                name="carnet" 
                id="carnet" 
                class="form-control @error('carnet') is-invalid @enderror" 
                value="{{ old('carnet') }}" 
                required 
                minlength="6" 
                maxlength="15" 
                pattern="\d+" 
                placeholder="Ingresa un carnet (6-15 dígitos)"
            >
            @error('carnet')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
        

        <div class="mb-3">
            <label for="telefono" class="form-label">Teléfono</label>
            <input type="text" name="telefono" id="telefono" class="form-control" value="{{ old('telefono') }}">
        </div>

        <div class="mb-3">
            <label for="observacion" class="form-label">Observaciones</label>
            <textarea name="observacion" id="observacion" class="form-control">{{ old('observacion') }}</textarea>
        </div>

        <button type="submit" class="btn btn-success">Registrar</button>
        <a href="{{ route('clientes.index') }}" class="btn btn-secondary">Volver</a>
    </form>
</div>
@endsection
