<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>{{ $pdfTitle }}</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; margin: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #000; padding: 8px; text-align: center; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2 style="text-align: center;">Reporte de Compras</h2>
    <p>Fecha de generación: {{ now()->format('d/m/Y H:i:s') }}</p>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Producto</th>
                <th>Código 1</th>
                <th>Ubicación</th>
                <th>Cantidad</th>
                <th>Costo Total</th>
                <th>Usuario</th>
                <th>Fecha y Hora</th>
                <th>Observación</th>
            </tr>
        </thead>
        <tbody>
            @foreach($compras as $index => $compra)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $compra->producto->nombre }}</td>
                    <td>{{ $compra->producto->codigo1 }}</td>
                    <td>{{ $compra->ubicacion->nombre }}</td>
                    <td>{{ $compra->cantidad }}</td>
                    <td>{{ number_format($compra->costo_total, 2) }} Bs.</td>
                    <td>{{ $compra->usuario->name }}</td>
                    <td>{{ \Carbon\Carbon::parse($compra->fecha_hora)->format('d/m/Y h:i A') }}</td>
                    <td>{{ $compra->observacion ?? 'N/A' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
