@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="section-header">
            <h3 class="page__heading text-light">
                Generar Usuario para {{$empleado->nombre}} {{$empleado->apellidos}} {{$empleado->correo}}
            </h3>
        </div>

        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
         
        </div>
    @endif
    
        <form action="{{ route('empleados.generateUser', $empleado->id) }}" method="POST">
            @csrf

            <div class="form-group">
                <label for="password">Contraseña:</label>
                <div class="input-group">
                    <input type="password" name="password" id="password" class="form-control" required>
                    <div class="input-group-append">
                        <span class="input-group-text toggle-password" id="togglePassword">
                            <i class="fa fa-eye-slash"></i>
                        </span>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="password_confirmation">Confirmar Contraseña:</label>
                <div class="input-group">
                    <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" required>
                    <div class="input-group-append">
                        <span class="input-group-text toggle-password" id="toggleConfirmPassword">
                            <i class="fa fa-eye-slash"></i>
                        </span>
                    </div>
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Generar Usuario</button>
        </form>
    </div>

    <script>
        document.querySelectorAll('.toggle-password').forEach((toggle) => {
            toggle.addEventListener('click', function () {
                const input = this.closest('.input-group').querySelector('input');
                const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
                input.setAttribute('type', type);

                this.querySelector('i').classList.toggle('fa-eye-slash');
                this.querySelector('i').classList.toggle('fa-eye');
            });
        });
    </script>
@endsection
