@extends('layouts.app')

@section('content')
<section class="section">
    <div class="section-header">
        <h3 class="page__heading">Inicio</h3>
    </div>

    <!-- Mensaje de Bienvenida -->
    <div class="alert alert-info">
        <h5 class="text-center">¡Bienvenido, {{ Auth::user()->name }}! 😊</h5>
        @can('administrador')
        <p class="text-center mb-0">Aquí puedes consultar el estado general del sistema, las sucursales, productos y ventas.</p>
        @endcan
    </div>
@can('administrador')
    <!-- Resumen General -->
    <div class="row">
        <div class="col-lg-4 col-md-6 col-sm-12">
            <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-store"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>Sucursales</h4>
                    </div>
                    <div class="card-body">
                        {{ $totalSucursales }}
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12">
            <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                    <i class="fas fa-user"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>Empleados</h4>
                    </div>
                    <div class="card-body">
                        {{ $totalEmpleados }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Productos con Bajo Stock -->
    <div class="card">
        <div class="card-header bg-warning text-white">
            <h4 class="mb-0">Productos con Bajo Stock</h4>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead class="bg-light">
                    <tr>
                        <th>Producto</th>
                        <th>Código</th>
                        <th>Cantidad</th>
                        <th>Ubicación</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productosConBajoStock as $producto)
                        <tr>
                            <td>{{ $producto->nombre }}</td>
                            <td>{{ $producto->codigo1 }}</td>
                            <td>{{ $producto->cantidad }}</td>
                            <td>{{ $producto->ubicacion->nombre ?? 'No especificada' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">No hay productos con bajo stock.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Productos Más Vendidos -->
    <div class="card">
        <div class="card-header bg-success text-white">
            <h4 class="mb-0">Productos Más Vendidos</h4>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead class="bg-light">
                    <tr>
                        <th>Producto</th>
                        <th>Código</th>
                        <th>Total Vendido</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productosMasVendidos as $producto)
                        <tr>
                            <td>{{ $producto->nombre }}</td>
                            <td>{{ $producto->codigo1 }}</td>
                            <td>{{ $producto->total_vendido }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="text-center">No hay productos vendidos aún.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Ventas por Fecha -->
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0" style="color: azure">Ventas por Fecha</h4>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead class="bg-light">
                    <tr>
                        <th>Fecha</th>
                        <th>Total Vendido</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($ventasPorFecha as $venta)
                        <tr>
                            <td>{{ $venta->fecha }}</td>
                            <td>{{ $venta->total_ventas }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="2" class="text-center">No hay ventas registradas.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                {{ $ventasPorFecha->links() }}
            </div>
        </div>
    </div>
</section>
@endcan
@endsection
