<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Productos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }

        header {
            text-align: center;
            margin-bottom: 20px;
        }

        header h1 {
            font-size: 20px;
            margin: 0;
        }

        header p {
            margin: 5px 0;
            font-size: 14px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: center;
        }

        th {
            background-color: #f4f4f4;
        }

        .total {
            text-align: right;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <header>
        <h1>Reporte de Productos</h1>
        <p>Generado el: {{ now()->format('d/m/Y H:i:s') }}</p>
    </header>
    <table>
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Código 1</th>
                <th>Código 2</th>
                <th>Descripción</th>
                <th>Marca</th>
                <th>Cantidad</th>
                <th>Ubicación</th>
                <th>Posición</th>
            </tr>
        </thead>
        <tbody>
            @foreach($productos as $producto)
                <tr>
                    <td>{{ $producto->nombre }}</td>
                    <td>{{ $producto->codigo1 }}</td>
                    <td>{{ $producto->codigo2 }}</td>
                    <td>{{ $producto->descripcion }}</td>
                    <td>{{ $producto->marca }}</td>
                    <td>{{ $producto->cantidad }}</td>
                    <td>{{ $producto->ubicacion->nombre ?? 'No especificada' }}</td>
                    <td>{{ $producto->posicion }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
