<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sticker Producto</title>
    <style>
        @page {
            margin: 0; /* Elimina los márgenes de la página */
        }
    
        body {
            font-family: Arial, sans-serif;
            font-size: 14px;
            width: 100%; /* Ajusta al ancho completo de la hoja */
            height: 100%; /* Ajusta al alto completo de la hoja */
            margin: 0; /* Elimina los márgenes */
            padding: 0; /* Elimina el relleno */
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            align-items: stretch;
            overflow: hidden;
        }
    
        .codigo2 {
            font-size: 50px; /* Más grande para máxima visibilidad */
            font-weight: bold;
            text-align: center;
            width: 100%; /* Abarca todo el ancho */
        }
    
        .barcode {
            text-align: center;
            margin-top: 1cm;
            width: 100%; /* Abarca el ancho completo */
        }
    
        .barcode img {
            max-width: 100%; /* Asegura que el código de barras se ajuste al ancho completo */
            height: auto;
        }
    
        .info-table {
            width: 100%; /* Abarca todo el ancho */
            border-collapse: collapse;
            font-size: 56px; /* Aumentado para visibilidad */
            font-weight: bold;
            margin-top: 3mm;
        }
    
        .info-table td {
            border: 1px solid #000; /* Bordes visibles para las celdas */
            padding: 15px; /* Más espaciado interno */
            text-align: center;
        }
    
        .highlight {
            font-size: 55px; /* Muy grande para destacar el precio principal */
            font-weight: bold;
            text-align: center;
            background-color: #f0f0f0;
            padding: 15px;
            width: 100%; /* Abarca todo el ancho */
        }
    
        .footer {
            font-size: 28px; /* Más grande para el texto del descuento/incremento */
            text-align: center;
            font-weight: bold;
            width: 100%; /* Abarca todo el ancho */
        }
    </style>
</head>
<body>
    <!-- Código 1 -->
    <div class="codigo2">
        {{ $producto->codigo1 }}
    </div>
    
    <!-- Código de barras -->
    <div class="barcode">
        <img src="data:image/png;base64,{{ $barcode }}" alt="Código de barras">
    </div>

    <!-- Tabla de precios -->
    <table class="info-table">
        <tr>
            <td>{{ number_format($producto->precio_paquete_normal, 1) }}</td>
      <td>{{ number_format($producto->precio_docena_caja, 1) }}</td>
        </tr>
        <tr>
         
                     <td>{{ number_format($producto->precio_docena_normal, 1) }}</td>
            <td>{{ $producto->piezas_por_caja }}</td>
        </tr>
    </table>

    <!-- Precio unidad -->
    <div class="highlight">
        {{ number_format($producto->precio_paquete_facturado, 1) }}
    </div>
    <div class="footer">
        <strong>PCS/Paquete</strong>   <strong>{{ $producto->piezas_por_paquete }}</strong>
       
    </div>

    <!-- Footer -->
    <div class="footer">
        @if($producto->descuento > 0)
            D %: 
        @elseif($producto->incremento > 0)
            O % 
        @endif
    </div>
</body>
</html>
