@extends('layouts.app')

@section('content')
<section class="section">
    <div class="section-header" style="background-color:#ffffff">
        <h3 class="page__heading" style="color: #0e25f8;">Usuarios</h3> <!-- Título con color acorde al logo -->
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    
    @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <div class="section-body">
        <div class="row">
            <div class="col-lg-12">
                <form action="{{ route('usuarios.index') }}" method="GET">
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" placeholder="Buscar por nombre, correo o rol" name="query">
                        <div class="input-group-append">
                            <button class="btn btn-outline-secondary" style="background-color: #2264f2; color: white;" type="submit">
                                <i class="fas fa-search"></i> <!-- Icono de búsqueda -->
                            </button>
                        </div>
                    </div>
                </form>
                
                <div class="card">
                    <div class="card-body">
                        <a class="btn btn-warning" href="{{ route('usuarios.create') }}" style="background-color: #159e2c; color: white;">
                            <i class="fas fa-user-plus"></i> <!-- Icono de agregar usuario -->
                        </a>
                        <a class="btn btn-primary" href="{{ route('usuarios.index') }}" style="background-color: #2330ec;">
                            <i class="fas fa-users"></i> <!-- Icono de ver todos los usuarios -->
                        </a>
                        <div class="table-responsive">
                            <table class="table table-striped mt-2">
                                <thead style="background-color:#2f2bec">
                                    <th style="display: none;">ID</th>
                                    <th style="color:#ffffff">Nombre</th>
                                    <th style="color:#fff;">E-mail</th>
                                    <th style="color:#fff;">Rol</th>
                                    <th style="color:#fff;">Estado</th>
                                    <th style="color:#fff;">Acciones</th>
                                </thead>
                                <tbody>
                                    @foreach($usuarios as $usuario)
                                    <tr>
                                        <td style="display: none;">{{$usuario->id}}</td>
                                        <td>{{$usuario->name}}</td>
                                        <td>{{$usuario->email}}</td>
                                        <td>
                                            @if(!empty($usuario->getRoleNames()))
                                                @foreach($usuario->getRoleNames() as $rolName)
                                                    <h5><span class="badge badge-dark">{{$rolName}}</span></h5>
                                                @endforeach
                                            @endif
                                        </td>
                                        <td>{{ $usuario->estado ? 'Activo' : 'Inactivo' }}</td> <!-- Mostrar el estado -->
                                        <td>
                                            <a class="btn btn-info" href="{{ route('usuarios.edit', $usuario->id) }}" style="background-color: #2330ec; color: white;">
                                                <i class="fas fa-edit"></i> <!-- Icono de editar -->
                                            </a>
                                            <form action="{{ route('usuarios.change-status', $usuario) }}" method="POST" style="display: inline-block;">
                                                @csrf
                                                @method('PATCH')
                                                <button type="submit" class="btn btn-sm {{ $usuario->estado ? 'btn-danger' : 'btn-success' }}">
                                                    <i class="fas fa-toggle-{{ $usuario->estado ? 'off' : 'on' }}"></i> <!-- Icono de activar/desactivar -->
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="pagination justify-content-end">
                            {!! $usuarios->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection