<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Ventas</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 20px;
        }

        header {
            text-align: center;
            margin-bottom: 20px;
        }

        header h1 {
            font-size: 16px;
            margin: 0;
        }

        header p {
            margin: 5px 0;
            font-size: 12px;
        }

        .venta-section {
            margin-bottom: 20px;
            border: 1px solid #ddd;
            padding: 10px;
            border-radius: 5px;
        }

        .venta-header {
            background-color: #f2f2f2;
            padding: 10px;
            margin-bottom: 10px;
        }

        .venta-header p {
            margin: 0;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: center;
            vertical-align: middle;
            word-wrap: break-word;
            font-size: 10px;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        .totales {
            margin-top: 20px;
            font-size: 12px;
            text-align: right;
        }

        .totales span {
            font-weight: bold;
        }

        footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #555;
        }
    </style>
</head>
<body>
    <header>
        <h1>Reporte de Ventas</h1>
        <p>Generado el {{ now()->subHours(4)->format('d/m/Y H:i:s') }}</p>

    </header>

    @php
        $montoTotalBs = 0;
    @endphp

    @foreach($ventas as $venta)
    <div class="venta-header">
        <p><strong>Venta ID:</strong> {{ $venta->id }}</p>
        <p><strong>Código:</strong> {{ $venta->codigo }}</p>
        <p><strong>Usuario:</strong> {{ $venta->usuario->name }}</p>
        <p><strong>Estado:</strong> {{ $venta->estado === 1 ? 'Aprobada' : 'Pendiente' }}</p>
        <p><strong>Aprobada por:</strong> {{ $venta->usuarioAprobador->name ?? 'No Aprobada' }}</p>
        <p><strong>Fecha:</strong> {{ \Carbon\Carbon::parse($venta->fecha)->format('d/m/Y') }}</p>
        <p><strong>Hora:</strong> {{ \Carbon\Carbon::parse($venta->hora)->subHours(4)->format('H:i:s') }}</p>
        <p><strong>Ubicacion:</strong> 
            {{ $venta->productosVendidos->pluck('producto.ubicacion.nombre')->unique()->implode(', ') ?? 'No especificada' }} 
        </p>
        <p><strong>Total de la Venta:</strong> {{ number_format($venta->precio_total, 2) }} Bs.</p>
    
        <!-- Información del cliente -->
        <p><strong>Cliente:</strong> {{ $venta->cliente->nombre ?? '__________________________' }} {{ $venta->cliente->apellidos ?? '__________________________' }}</p>
        <p><strong>Carnet:</strong> {{ $venta->cliente->carnet ?? '__________________________' }}</p>
        <p><strong>Observaciones:</strong> {{ $venta->observacion ?? '__________________________' }}</p>
    </div>
    

            <!-- Productos de la venta -->
            <table>
                <thead>
                    <tr>
                        <th>Producto</th>
                        <th>Código</th>
                        <th>Descripción</th>
                        <th>Ubicación</th>
                        <th>Marca</th>
                        <th>Tipo de Precio</th>
                        <th>Cantidad</th>
                        <th>Cantidad Total</th>
                        <th>Precio  (Bs.)</th>
                        <th>Total (Bs.)</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($venta->productosVendidos as $productoVendido)
                        @php
                            $montoTotalBs += $productoVendido->precio_total;
                        @endphp
                        <tr>
                            <td>{{ $productoVendido->producto->nombre }}</td>
                            <td>{{ $productoVendido->producto->codigo1 }}</td>
                            <td>{{ $productoVendido->producto->descripcion }}</td>
                            <td>{{ $productoVendido->producto->ubicacion->nombre ?? 'No especificada' }}</td>
                            <td>{{ $productoVendido->producto->marca }}</td>
                            <td>{{ $productoVendido->tipo_precio }}</td>
                            <td>{{ $productoVendido->cantidad }}</td>
                            <td>{{ $productoVendido->cantidad_total }}</td>
                            <td>{{ number_format($productoVendido->precio, 2) }} Bs.</td>
                            <td>{{ number_format($productoVendido->precio_total, 2) }} Bs.</td>
                        </tr>
                    @endforeach
                </tbody>
         

            </table>
        </div>
    @endforeach

    <div class="totales">
        <p><span>Monto Total Vendido (Bs.):</span> {{ number_format($montoTotalBs, 2) }}</p>
    </div>

    <footer>
        <p>Reporte generado automáticamente por el sistema.</p>
    </footer>
</body>
</html>
