<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen de Venta</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            width: 80mm;
            margin: 0 auto;
            padding: 5mm;
            color: #333;
            text-align: left;
            box-sizing: border-box;
            margin-right: 10px;
        }

        header {
            margin-bottom: 10px;
        }

        header h1 {
            font-size: 14px;
            margin: 0;
            color: #555;
        }

        header p {
            font-size: 10px;
            margin: 2px 0;
            color: #666;
        }

        .venta-info, .producto-info {
            margin-bottom: 10px;
            text-align: left;
        }

        .venta-info p, .producto-info p {
            margin: 3px 0;
            line-height: 1.2;
        }

        .separator {
            border-bottom: 1px dashed #aaa;
            margin: 5px 0;
        }

        .footer-info {
            margin-top: 10px;
            font-size: 9px;
            text-align: left;
            margin-right: 10px;
        }

        .footer-info p {
            margin: 3px 0;
        }

        .footer-info strong {
            font-size: 10px;
        }

        .observaciones {
            text-align: left;
            margin-top: 20px;
        }

        .observaciones p {
            margin: 0;
        }

        .observaciones strong {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    <header>
        <h1>Resumen de Venta</h1>
        <p>Generado el: {{ now()->subHours(4)->format('d/m/Y H:i:s') }}</p>
          <p><strong>Codigo:</strong> {{ $venta->codigo}}</p>
    </header>

    <div class="venta-info">
        <p><strong>Nombre:</strong> {{ $venta->cliente->nombre ?? '__________________________' }} {{ $venta->cliente->apellidos ?? '__________________________' }}</p>
        <p><strong>Destino:</strong> __________________________</p>
        <p><strong>NIT:</strong> {{ $venta->cliente->carnet ?? '__________________________' }}</p>
        <p><strong>Transportadora:</strong> __________________________</p>
        <p><strong>Fecha:</strong> {{ \Carbon\Carbon::parse($venta->fecha)->format('d/m/Y') }}</p>
    </div>

    <div class="separator"></div>

    @foreach($venta->productosVendidos as $productoVendido)
        <div class="producto-info">
            <p><strong>Código:</strong> {{ $productoVendido->producto->codigo1 }}</p>
            <p><strong>Producto:</strong> {{ $productoVendido->producto->nombre }}</p>
            <p><strong>Cantidad:</strong> {{ $productoVendido->cantidad }} {{ $productoVendido->tipo_medida }}</p>
            <p><strong>Precio:</strong> {{ number_format($productoVendido->precio, 2) }} Bs.</p>
            <p><strong>Total:</strong> {{ number_format($productoVendido->precio_total, 2) }} Bs.</p>
        </div>
        <div class="separator"></div>
    @endforeach

    <div class="footer-info">
        <p><strong>Total Venta:</strong> {{ number_format($venta->precio_total, 2) }} Bs.</p>
    </div>

    <div class="footer-info">
        <p><strong>Nota:</strong> Por favor, revise cuidadosamente los productos </p>
        <p>entregados.</p>
            <p> Cualquier reclamo o solicitud de ajuste deberá realizarse </p>
               <p>dentro de un plazo máximo de <strong>10 días calendario</strong> </p>
              <p>  a partir de la fecha de compra. </p>  
                <p>Pasado este periodo, no se aceptarán cambios </p>
                <p>ni devoluciones.</p>
    </div>

    <div class="observaciones">
        
    <p><strong>Observaciones:</strong> {{ $venta->observacion ?? '__________________________' }}</p>

    </div>
</body>
</html>
