

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="section-header">
            <h3 class="page__heading text-light">
                Generar Usuario para <?php echo e($empleado->nombre); ?> <?php echo e($empleado->apellidos); ?> <?php echo e($empleado->correo); ?>

            </h3>
        </div>

        <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            
        </div>
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

         
        </div>
    <?php endif; ?>
    
        <form action="<?php echo e(route('empleados.generateUser', $empleado->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="password">Contraseña:</label>
                <div class="input-group">
                    <input type="password" name="password" id="password" class="form-control" required>
                    <div class="input-group-append">
                        <span class="input-group-text toggle-password" id="togglePassword">
                            <i class="fa fa-eye-slash"></i>
                        </span>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="password_confirmation">Confirmar Contraseña:</label>
                <div class="input-group">
                    <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" required>
                    <div class="input-group-append">
                        <span class="input-group-text toggle-password" id="toggleConfirmPassword">
                            <i class="fa fa-eye-slash"></i>
                        </span>
                    </div>
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Generar Usuario</button>
        </form>
    </div>

    <script>
        document.querySelectorAll('.toggle-password').forEach((toggle) => {
            toggle.addEventListener('click', function () {
                const input = this.closest('.input-group').querySelector('input');
                const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
                input.setAttribute('type', type);

                this.querySelector('i').classList.toggle('fa-eye-slash');
                this.querySelector('i').classList.toggle('fa-eye');
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/offsides/public_html/resources/views/empleados/generate_user.blade.php ENDPATH**/ ?>