<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sticker Producto PPN</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            width: 5.5cm; /* Ancho 5.5cm */
            height: 4.5cm; /* Alto 4.5cm */
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
            align-items: stretch;
            overflow: hidden;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 22px; /* Reducido para que los números se ajusten */
            margin: 0;
            padding: 0;
            font-weight: bold;
        }

        .info-table td {
            border: 1px solid #000;
            padding: 2mm;
            text-align: center;
            font-size: 22px; /* Aumentado para mejor visibilidad */
        }

        .highlight {
            font-size: 17px; /* Aumentado */
            text-align: center;
            margin-top: 0.5mm;
            font-weight: bold;
            background-color: #f0f0f0;
            border-radius: 3px;
            padding: 4px 0;
        }

        .footer {
            font-size: 10px; /* Aumentado para visibilidad */
            text-align: center;
            margin-top: 0.1mm;
        }

        .codigo2 {
            font-size: 12px; /* Aumentado */
            font-weight: bold;
            text-align: center;
            margin-top: 0.1mm;
        }

        .info-table td {
            font-size: 20px; /* Aumentado */
            font-weight: bold;
            background-color: #f9f9f9;
        }

        .footer strong {
            font-size: 12px; /* Aumentado */
            font-weight: bold;
            color: #000;
        }
    </style>
</head>
<body>
    <!-- Código 1 -->
    <div class="codigo2">
        <?php echo e($producto->codigo1); ?>

    </div>

    <!-- Código 2 -->
    <div class="codigo2">
        <?php echo e($producto->codigo2); ?>

    </div>

    <!-- Tabla de Precios -->
    <table class="info-table">
        <tr>
            <td><?php echo e(number_format($producto->precio_paquete_normal, 1)); ?></td>
            <td><?php echo e(number_format($producto->precio_docena_normal, 1)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(number_format($producto->precio_docena_caja, 1)); ?></td>
            <td><?php echo e($producto->piezas_por_caja); ?></td>
        </tr>
    </table>

    <!-- Precio Unidad Facturado -->
    <div class="highlight">
        <strong><?php echo e(number_format($producto->precio_paquete_facturado, 1)); ?></strong> 
    </div>

    <!-- PPN y PPF -->
    <div class="footer">
        <strong>PCS/Paquete</strong>   <strong><?php echo e($producto->piezas_por_paquete); ?></strong>
       
    </div>

    <!-- Incremento o Descuento -->
    <?php if($producto->descuento > 0 || $producto->incremento > 0): ?>
        <div class="footer">
            <strong><?php echo e($producto->descuento > 0 ? 'D %' : 'O %'); ?></strong>
        </div>
    <?php endif; ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\jugueteria\resources\views/mercancia/sticker_ppn.blade.php ENDPATH**/ ?>