<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen para Almacén</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            width: 80mm;
            margin: 0 auto;
            padding: 5mm;
            color: #333;
            text-align: left;
            box-sizing: border-box;
        }

        header {
            margin-bottom: 10px;
        }

        header h1 {
            font-size: 14px;
            margin: 0;
            color: #555;
        }

        header p {
            font-size: 10px;
            margin: 2px 0;
            color: #666;
        }

        .venta-info, .producto-info {
            margin-bottom: 10px;
            text-align: left;
        }

        .venta-info p, .producto-info p {
            margin: 3px 0;
            line-height: 1.2;
        }

        .separator {
            border-bottom: 1px dashed #aaa;
            margin: 5px 0;
        }

        .footer-info {
            margin-top: 10px;
            font-size: 9px;
            text-align: left;
            margin-right: 10px;
        }

        .footer-info p {
            margin: 3px 0;
        }

        .footer-info strong {
            font-size: 10px;
        }

        .observaciones {
            text-align: left;
            margin-top: 20px;
        }

        .observaciones p {
            margin: 0;
        }

        .observaciones strong {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    <header>
        <h1>Resumen para Almacén</h1>
        <p>Generado el: <?php echo e(now()->subHours(4)->format('d/m/Y H:i:s')); ?></p>
    </header>

    <div class="venta-info">
        <p><strong>Código de Venta:</strong> <?php echo e($venta->codigo); ?></p>
        <p><strong>Usuario que generó la venta:</strong> <?php echo e($venta->usuario->name); ?></p>
        <p><strong>Usuario que aprobó la venta:</strong> <?php echo e($venta->usuarioAprobador->name); ?></p>
    </div>

    <div class="separator"></div>

    <?php $__currentLoopData = $venta->productosVendidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productoVendido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="producto-info">
            <p><strong>Código:</strong> <?php echo e($productoVendido->producto->codigo1); ?></p>
            <p><strong>Producto:</strong> <?php echo e($productoVendido->producto->nombre); ?></p>
            <p><strong>Descripcion:</strong> <?php echo e($productoVendido->producto->descripcion); ?></p>
            <p><strong>Posición:</strong> <?php echo e($productoVendido->producto->posicion); ?></p>
            <p><strong>Cantidad Total:</strong> <?php echo e($productoVendido->cantidad_total); ?></p>
        </div>
        <div class="separator"></div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="footer-info">
        <p><strong>Nota:</strong> Este resumen es únicamente para uso interno </p>
    <p>del almacén y debe manejarse con confidencialidad.</p>
    </div>

    <div class="observaciones">
        <p><strong>Observaciones:</strong> <?php echo e($venta->observacion ?? '__________________________'); ?></p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\jugueteria\resources\views/ventas/almacen-pdf.blade.php ENDPATH**/ ?>