

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="card shadow-sm border-0 rounded">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Gestión de Empleados</h2>
            <a href="<?php echo e(route('empleados.create')); ?>" class="btn btn-light">
                <i class="fas fa-plus-circle"></i> Agregar Empleado
            </a>
        </div>
        <div class="card-body">
       
            <?php if(session('success')): ?>
            <div class="alert alert-success mt-3">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger mt-3">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
        <?php if(isset($error)): ?>
            <div class="alert alert-danger mt-3">
                <?php echo e($error); ?>

            </div>
        <?php endif; ?>
            <!-- Filtros y Buscador -->
            <form method="GET" action="<?php echo e(route('empleados.index')); ?>" class="mb-4">
                <div class="row g-3">
                    <div class="col-lg-4">
                        <input type="text" name="search" class="form-control" placeholder="Buscar por carnet, nombre o apellidos" value="<?php echo e(request('search')); ?>">
                    </div>
                    <div class="col-lg-4">
                        <select name="sucursal_id" class="form-select">
                            <option value="">Filtrar por sucursal</option>
                            <?php $__currentLoopData = $ubicaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ubicacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ubicacion->id); ?>" <?php echo e(request('sucursal_id') == $ubicacion->id ? 'selected' : ''); ?>>
                                    <?php echo e($ubicacion->nombre); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-lg-4 d-flex gap-2">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-filter"></i> Filtrar
                        </button>
                        <a href="<?php echo e(route('empleados.index')); ?>" class="btn btn-secondary w-100">
                            <i class="fas fa-sync"></i> Limpiar
                        </a>
                    </div>
                </div>
            </form>

            <!-- Tabla de empleados -->
            <div class="table-responsive">
                <table class="table table-hover table-bordered align-middle text-center">
                    <thead class="bg-light">
                        <tr>
                       
                            <th>Nombre</th>
                            <th>Apellidos</th>
                            <th>Carnet</th>
                            <th>Fecha de nacimiento</th>
                            <th>Telefono</th>
                            <th>Correo</th>
                            <th>Sucursal</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $empleados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empleado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                         
                                <td><?php echo e($empleado->nombre); ?></td>
                                <td><?php echo e($empleado->apellidos); ?></td>
                                <td><?php echo e($empleado->carnet); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($empleado->fecha_nacimiento)->format('d/m/Y')); ?></td>


                                <td><?php echo e($empleado->telefono); ?></td>
                                <td><?php echo e($empleado->correo); ?></td>
                                <td><?php echo e($empleado->sucursal->nombre ?? 'Sin asignar'); ?></td>
                                <td>
                                    <span class="badge <?php echo e($empleado->estado ? 'bg-success' : 'bg-danger'); ?>">
                                        <?php echo e($empleado->estado ? 'Activo' : 'Inactivo'); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group" aria-label="Acciones">
                                        <!-- Botón Editar -->
                                        <a href="<?php echo e(route('empleados.edit', $empleado->id)); ?>" class="btn btn-warning btn-sm" title="Editar Empleado">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    
                                        <!-- Botón Activar/Desactivar -->
                                        <form action="<?php echo e(route('empleados.destroy', $empleado->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm" title="<?php echo e($empleado->estado ? 'Desactivar Empleado' : 'Activar Empleado'); ?>">
                                                <i class="fas fa-user-slash"></i>
                                            </button>
                                        </form>
                                    
                                        <!-- Botón Generar Usuario (Sólo si el empleado está activo) -->
                                        <?php if($empleado->estado): ?>
                                            <form action="<?php echo e(route('empleados.generateUserForm', $empleado->id)); ?>" method="get">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-success btn-sm" title="Generar Usuario">
                                                    <i class="fas fa-user-cog"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted">No se encontraron empleados.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($empleados->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elcomerc/public_html/resources/views/empleados/index.blade.php ENDPATH**/ ?>