

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="section-header">
            <h3 class="page__heading">Configuración</h3>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">
                <h4>Configuración de Traspasos</h4>
            </div>
            <div class="card-body">
                <?php if($configuracion): ?>
                    <p>Última cantidad máxima: <?php echo e($configuracion->cantidad_maxima); ?></p>
                    <p>Nombre del sistema: <?php echo e($configuracion->nombre_sistema); ?></p>
                    <?php if($configuracion->logo_path): ?>
                        <img src="<?php echo e(asset('storage/' . $configuracion->logo_path)); ?>" alt="logo" width="100">
                    <?php endif; ?>
                <?php endif; ?>

                <form action="<?php echo e(route('configuracion.update')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="form-group">
                        <label for="cantidad_maxima">Nueva Cantidad Máxima:</label>
                        <input type="number" name="cantidad_maxima" class="form-control" value="<?php echo e(old('cantidad_maxima', $configuracion->cantidad_maxima ?? '')); ?>">
                    </div>

                    <div class="form-group">
                        <label for="nombre_sistema">Nombre del Sistema:</label>
                        <input type="text" name="nombre_sistema" class="form-control" value="<?php echo e(old('nombre_sistema', $configuracion->nombre_sistema ?? '')); ?>">
                    </div>

                    <div class="form-group">
                        <label for="logo">Nuevo Logo:</label>
                        <input type="file" name="logo" class="form-control">
                    </div>

                    <button type="submit" class="btn btn-primary">Guardar</button>
                </form>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elcomerc/public_html/resources/views/configuracion/mostrar.blade.php ENDPATH**/ ?>