<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen de Venta</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            width: 80mm;
            margin: 0 auto;
            padding: 5mm;
            color: #333;
            text-align: left;
            box-sizing: border-box;
            margin-right: 10px;
        }

        header {
            margin-bottom: 10px;
        }

        header h1 {
            font-size: 14px;
            margin: 0;
            color: #555;
        }

        header p {
            font-size: 10px;
            margin: 2px 0;
            color: #666;
        }

        .venta-info, .producto-info {
            margin-bottom: 10px;
            text-align: left;
        }

        .venta-info p, .producto-info p {
            margin: 3px 0;
            line-height: 1.2;
        }

        .separator {
            border-bottom: 1px dashed #aaa;
            margin: 5px 0;
        }

        .footer-info {
            margin-top: 10px;
            font-size: 9px;
            text-align: left;
            margin-right: 10px;
        }

        .footer-info p {
            margin: 3px 0;
        }

        .footer-info strong {
            font-size: 10px;
        }

        .observaciones {
            text-align: left;
            margin-top: 20px;
        }

        .observaciones p {
            margin: 0;
        }

        .observaciones strong {
            margin-right: 5px;
        }
    </style>
</head>
<body>
    <header>
        <h1>Resumen de Venta</h1>
        <p>Generado el: <?php echo e(now()->subHours(4)->format('d/m/Y H:i:s')); ?></p>
          <p><strong>Codigo:</strong> <?php echo e($venta->codigo); ?></p>
    </header>

    <div class="venta-info">
        <p><strong>Nombre:</strong> <?php echo e($venta->cliente->nombre ?? '__________________________'); ?> <?php echo e($venta->cliente->apellidos ?? '__________________________'); ?></p>
        <p><strong>Destino:</strong> __________________________</p>
        <p><strong>NIT:</strong> <?php echo e($venta->cliente->carnet ?? '__________________________'); ?></p>
        <p><strong>Transportadora:</strong> __________________________</p>
        <p><strong>Fecha:</strong> <?php echo e(\Carbon\Carbon::parse($venta->fecha)->format('d/m/Y')); ?></p>
    </div>

    <div class="separator"></div>

    <?php $__currentLoopData = $venta->productosVendidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productoVendido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="producto-info">
            <p><strong>Código:</strong> <?php echo e($productoVendido->producto->codigo1); ?></p>
            <p><strong>Producto:</strong> <?php echo e($productoVendido->producto->nombre); ?></p>
            <p><strong>Cantidad:</strong> <?php echo e($productoVendido->cantidad); ?> <?php echo e($productoVendido->tipo_medida); ?></p>
            <p><strong>Precio:</strong> <?php echo e(number_format($productoVendido->precio, 2)); ?> Bs.</p>
            <p><strong>Total:</strong> <?php echo e(number_format($productoVendido->precio_total, 2)); ?> Bs.</p>
        </div>
        <div class="separator"></div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="footer-info">
        <p><strong>Total Venta:</strong> <?php echo e(number_format($venta->precio_total, 2)); ?> Bs.</p>
    </div>

    <div class="footer-info">
        <p><strong>Nota:</strong> Por favor, revise cuidadosamente los productos </p>
        <p>entregados.</p>
            <p> Cualquier reclamo o solicitud de ajuste deberá realizarse </p>
               <p>dentro de un plazo máximo de <strong>10 días calendario</strong> </p>
              <p>  a partir de la fecha de compra. </p>  
                <p>Pasado este periodo, no se aceptarán cambios </p>
                <p>ni devoluciones.</p>
    </div>

    <div class="observaciones">
        
    <p><strong>Observaciones:</strong> <?php echo e($venta->observacion ?? '__________________________'); ?></p>

    </div>
</body>
</html>
<?php /**PATH /home/elcomerc/public_html/resources/views/ventas/simple-pdf.blade.php ENDPATH**/ ?>