<?php require('fpdf/fpdf.php');
  include('qrgen/lib/full/qrlib.php');
  
include('casa/setup.casa.php');
$id = DataForms::GET('id');
$titulo = 'Generar QR Producto';

$file = 'qr-imprimir';

class PDF extends FPDF{
    //HTML
protected $B = 0;
protected $I = 0;
protected $U = 0;
protected $HREF = '';

function WriteHTML($html){
    // Intérprete de HTML
    $html = str_replace("\n",' ',$html);
    $a = preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE);
    foreach($a as $i=>$e){
        if($i%2==0){
            // Text
            if($this->HREF)
                $this->PutLink($this->HREF,$e);
            else
                $this->Write(5,$e);
        }else{
            // Etiqueta
            if($e[0]=='/')
                $this->CloseTag(strtoupper(substr($e,1)));
            else{
                // Extraer atributos
                $a2 = explode(' ',$e);
                $tag = strtoupper(array_shift($a2));
                $attr = array();
                foreach($a2 as $v){
                    if(preg_match('/([^=]*)=["\']?([^"\']*)/',$v,$a3))
                        $attr[strtoupper($a3[1])] = $a3[2];
                }
                $this->OpenTag($tag,$attr);
            }
        }
    }
}
function SetStyle($tag, $enable){
    $this->$tag += ($enable ? 1 : -1);
    $style = '';
    foreach(array('B', 'I', 'U') as $s){
        if($this->$s>0)
            $style .= $s;
    }
    $this->SetFont('',$style);
}
function CloseTag($tag){
    if($tag=='B' || $tag=='I' || $tag=='U')
        $this->SetStyle($tag,false);
    if($tag=='A')
        $this->HREF = '';
}
function OpenTag($tag, $attr){
    if($tag=='B' || $tag=='I' || $tag=='U')
        $this->SetStyle($tag,true);
    if($tag=='A')
        $this->HREF = $attr['HREF'];
    if($tag=='BR')
        $this->Ln(5);
}


}
//vertical P
//Horizontal L
//$pdf = new PDF('L','mm','Letter');
//$pdf = new PDF('P','mm','Letter'); array(ancho, alto)
  $pdf = new PDF('P','mm',array(200,90));
  $pdf->SetMargins(0,0,0);
  $pdf->SetAutoPageBreak(true,1); 
$pdf->SetFont('Arial','',10);
$pdf->AddPage();
//$qrgen = QRcode::png($id);
$qrgen = QRcode::png($id, 'qrs/qrgen.png', QR_ECLEVEL_H);
$pdf->Image('qrs/qrgen.png',0,0,90,90);
$pdf->Image('qrs/logosys.jpg',0,80,100,120);
$file = 'qrs/qr';
$pdf->Output($file.'.pdf','F');

$report = "<script>self.location='".PATH_HOME."qrs/qr.pdf';</script>";
echo $report;
?>